/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import de.mennomax.astikorcarts.util.Mat4f;
import de.mennomax.astikorcarts.util.Quat4f;
import java.util.ArrayDeque;
import java.util.Deque;

public final class MatrixStack
implements AutoCloseable {
    private final Deque<Mat4f> stack = new ArrayDeque<Mat4f>();

    public MatrixStack() {
        Mat4f mat = new Mat4f();
        mat.makeIdentity();
        this.stack.addFirst(mat);
    }

    private Mat4f newMatrix() {
        return new Mat4f();
    }

    public MatrixStack push() {
        this.stack.addFirst(new Mat4f(this.matrix()));
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public MatrixStack pop() {
        this.stack.removeFirst();
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underflow");
        }
        return this;
    }

    public void makeIdentity() {
        this.matrix().makeIdentity();
    }

    public void translate(float x, float y, float z) {
        Mat4f mat = this.matrix();
        Mat4f translation = this.newMatrix();
        translation.makeTranslation(x, y, z);
        mat.mul(translation);
    }

    public void rotate(float angle, float x, float y, float z) {
        Mat4f mat = this.matrix();
        Mat4f rotation = this.newMatrix();
        rotation.makeRotation(angle, x, y, z);
        mat.mul(rotation);
    }

    public void rotate(Quat4f quat) {
        Mat4f mat = this.matrix();
        Mat4f rotation = this.newMatrix();
        rotation.makeQuaternion(quat);
        mat.mul(rotation);
    }

    public void scale(float x, float y, float z) {
        Mat4f mat = this.matrix();
        Mat4f scale = this.newMatrix();
        scale.makeScale(x, y, z);
        mat.mul(scale);
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        Mat4f mat = this.matrix();
        Mat4f scale = this.newMatrix();
        scale.makePerspective(fovy, aspect, zNear, zFar);
        mat.mul(scale);
    }

    public void mul(Mat4f other) {
        Mat4f mat = this.matrix();
        mat.mul(other);
    }

    public Mat4f matrix() {
        return this.stack.getFirst();
    }
}

